/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import com.google.common.collect.Sets;
import dev.itsmeow.betteranimalsplus.api.ModEventBus;
import dev.itsmeow.betteranimalsplus.common.entity.ai.WaterfowlNavigator;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IVariantTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.init.ModSoundEvents;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1399;
import net.minecraft.class_1405;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6862;
import net.minecraft.class_7;

public class EntityGoose
extends EntityAnimalWithTypes {
    public int attacksLeft = 0;
    public int lastAttackTime = 0;
    protected final Set<UUID> dislikedPlayers = new HashSet<UUID>();
    private int eatTicks;
    private static final Predicate<class_1542> ITEM_SELECTOR = item -> !item.method_6977() && item.method_5805();
    public int timeUntilNextEgg;
    public static final String PICKUP_BLOCK_LIST_KEY = "pickup_blacklist";
    private static final Set<class_1792> BREEDING_ITEMS = Sets.newHashSet((Object[])new class_1792[]{class_1802.field_8706, class_1802.field_8317, class_1802.field_8309, class_1802.field_8188, class_1802.field_8158});

    public EntityGoose(class_1299<? extends EntityGoose> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.method_5952(true);
        this.timeUntilNextEgg = this.field_5974.nextInt(6000) + 6000;
        this.method_5941(class_7.field_18, 0.0f);
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return new WaterfowlNavigator((class_1308)this, worldIn);
    }

    protected float method_6120() {
        return 0.95f;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 1.4){

            public boolean method_6264() {
                return this.field_6549.method_5968() == null && super.method_6264();
            }
        });
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8706, class_1802.field_8317, class_1802.field_8309, class_1802.field_8188, class_1802.field_8158, class_1802.field_8229}), false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(6, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new FindItemsGoal());
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 1.1, false){

            public void method_6269() {
                EntityGoose.this.attacksLeft = this.field_6503.method_6051().nextInt(4) + 1;
                super.method_6269();
            }

            public boolean method_6264() {
                return super.method_6264() && this.field_6503.field_6012 - EntityGoose.this.lastAttackTime > 150 && !EntityGoose.this.isPassive();
            }

            public boolean method_6266() {
                return EntityGoose.this.attacksLeft > 0 && super.method_6266();
            }

            protected void method_6288(class_1309 p_190102_1_, double p_190102_2_) {
                if (EntityGoose.this.attacksLeft > 0) {
                    super.method_6288(p_190102_1_, p_190102_2_);
                } else {
                    this.method_6270();
                }
            }

            public void method_6270() {
                super.method_6270();
                if (EntityGoose.this.attacksLeft <= 0) {
                    this.field_6503.method_5980(null);
                }
            }
        });
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]){

            public boolean method_6264() {
                return super.method_6264() && !EntityGoose.this.isPassive();
            }
        }.method_6318(new Class[]{EntityGoose.class}));
        this.field_6185.method_6277(1, (class_1352)new DislikeTargetGoal(this){

            @Override
            public boolean method_6264() {
                return super.method_6264() && !EntityGoose.this.isPassive();
            }
        });
    }

    public boolean method_6481(class_1799 itemStack) {
        return BREEDING_ITEMS.contains(itemStack.method_7909());
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return sizeIn.field_18068;
    }

    protected boolean isPassive() {
        return this.getVariantString().equals("1") || this.field_6002.method_8407() == class_1267.field_5801;
    }

    public void method_6007() {
        class_1799 itemstack;
        super.method_6007();
        if (!this.field_6002.field_9236 && this.method_5805() && this.method_6034() && (itemstack = this.method_6118(class_1304.field_6173)).method_7909().method_19263() && this.method_5968() == null) {
            ++this.eatTicks;
            if (this.eatTicks > 200) {
                class_1799 itemstack1;
                if (itemstack.method_7909() == class_1802.field_8229) {
                    this.method_6092(new class_1293(class_1294.field_5899, 900));
                }
                if (!(itemstack1 = itemstack.method_7910(this.field_6002, (class_1309)this)).method_7960()) {
                    this.method_5673(class_1304.field_6173, itemstack1);
                }
                this.eatTicks = 0;
            } else if (this.eatTicks > 160 && this.field_5974.nextFloat() < 0.1f) {
                this.method_5783(this.method_18869(itemstack), 1.0f, 1.0f);
                this.field_6002.method_8421((class_1297)this, (byte)45);
            }
        }
        if (!this.field_6002.field_9236 && !this.method_6109() && ModEventBus.LayEggTickEvent.emit((class_1309)this) && --this.timeUntilNextEgg <= 0) {
            this.method_5783(class_3417.field_15219, 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
            this.method_5870(this.method_6051().nextInt(128) == 0 ? (class_1935)ModItems.GOLDEN_GOOSE_EGG.get() : (class_1935)ModItems.GOOSE_EGG.get(), 1);
            this.timeUntilNextEgg = this.field_5974.nextInt(6000) + 6000;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_5711(byte id) {
        if (id == 45) {
            class_1799 stack = this.method_6118(class_1304.field_6173);
            if (!stack.method_7960()) {
                for (int i = 0; i < 8; ++i) {
                    class_243 vec3d = new class_243(((double)this.field_5974.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).method_1037(-this.method_36455() * ((float)Math.PI / 180)).method_1024(-this.method_36454() * ((float)Math.PI / 180));
                    this.field_6002.method_8406((class_2394)new class_2392(class_2398.field_11218, stack), this.method_23317() + this.method_5720().field_1352 / 2.0, this.method_23318(), this.method_23321() + this.method_5720().field_1350 / 2.0, vec3d.field_1352, vec3d.field_1351 + 0.05, vec3d.field_1350);
                }
            }
        } else {
            super.method_5711(id);
        }
    }

    public void method_5980(class_1309 entity) {
        super.method_5980(entity);
        if (entity instanceof class_1657) {
            UUID uuid = ((class_1657)entity).method_7334().getId();
            this.dislikedPlayers.add(uuid);
        }
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.attacksLeft > 0) {
            --this.attacksLeft;
        }
        this.lastAttackTime = this.field_6012;
        return super.method_6121(entityIn);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() != null && source.method_5529() != null && source.method_5529() == this.method_5968()) {
            this.lastAttackTime = 0;
        }
        return super.method_5643(source, amount);
    }

    protected void method_16080(class_1282 damageSourceIn) {
        class_1799 itemstack = this.method_6118(class_1304.field_6173);
        if (!itemstack.method_7960()) {
            this.method_5775(itemstack);
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        super.method_16080(damageSourceIn);
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 type = class_1308.method_32326((class_1799)stack);
        if (!this.method_6118(type).method_7960()) {
            return false;
        }
        return type == class_1304.field_6173 && super.method_18397(stack);
    }

    public boolean method_5939(class_1799 newStack) {
        class_1799 oldStack = this.method_6118(class_1304.field_6173);
        return !this.isPickupBlacklisted(newStack.method_7909()) && (oldStack.method_7960() || this.eatTicks == 0 && newStack.method_7909().method_19263() && !oldStack.method_7909().method_19263());
    }

    public boolean isPickupBlacklisted(class_1792 item) {
        for (String itemsId : this.getContainer().getCustomConfiguration().getAnyHolder(List.class, PICKUP_BLOCK_LIST_KEY).get()) {
            if (!(itemsId.startsWith("#") ? item.method_40131().method_40220(class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(itemsId.substring(1)))) : itemsId.equals(class_2378.field_11142.method_10221((Object)item).toString()))) continue;
            return true;
        }
        return false;
    }

    private void dropItem(class_1799 stack) {
        if (!stack.method_7960() && !this.field_6002.field_9236) {
            class_1542 itementity = new class_1542(this.field_6002, this.method_23317() + this.method_5720().field_1352, this.method_23318() + 1.0, this.method_23321() + this.method_5720().field_1350, stack);
            itementity.method_6982(40);
            itementity.method_6981(this.method_5667());
            this.method_5783(class_3417.field_18054, 1.0f, 1.0f);
            this.field_6002.method_8649((class_1297)itementity);
        }
    }

    private void spawnItem(class_1799 stack) {
        class_1542 entity = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), stack);
        this.field_6002.method_8649((class_1297)entity);
    }

    public class_3414 method_5994() {
        return (class_3414)ModSoundEvents.GOOSE_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSoundEvents.GOOSE_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSoundEvents.GOOSE_DEATH.get();
    }

    protected void method_5949(class_1542 itemEntity) {
        class_1799 stack = itemEntity.method_6983();
        if (this.method_5939(stack)) {
            int i = stack.method_7947();
            if (i > 1) {
                this.spawnItem(stack.method_7971(i - 1));
            }
            this.dropItem(this.method_6118(class_1304.field_6173));
            this.method_5673(class_1304.field_6173, stack.method_7971(1));
            this.field_6187[class_1304.field_6173.method_5927()] = 2.0f;
            this.method_6103((class_1297)itemEntity, stack.method_7947());
            itemEntity.method_31472();
            this.eatTicks = 0;
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_2499 list = new class_2499();
        for (UUID uuid : this.dislikedPlayers) {
            list.add((Object)class_2519.method_23256((String)uuid.toString()));
        }
        compound.method_10566("disliked_players", (class_2520)list);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        compound.method_10554("disliked_players", 8).forEach(nbt -> this.dislikedPlayers.add(UUID.fromString(nbt.method_10714())));
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 reason, class_1315 livingdata, class_2487 compound) {
        String[] types = switch (reason) {
            case class_3730.field_16459 -> new String[]{"2", "3"};
            case class_3730.field_16472 -> new String[]{"2", "3"};
            case class_3730.field_16474 -> new String[]{"2", "3"};
            case class_3730.field_16466 -> new String[]{"1"};
            default -> new String[]{"1", "2", "3"};
        };
        livingdata = EntityUtil.childChance((class_1296)this, reason, livingdata, 0.25f);
        IVariant variant = this.getContainer().getVariantForName(types[this.method_6051().nextInt(types.length)]).get();
        if (livingdata instanceof IVariantTypes.AgeableTypeData) {
            variant = ((IVariantTypes.AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof class_1296.class_4697 ? new IVariantTypes.AgeableTypeData((class_1296.class_4697)livingdata, variant) : new IVariantTypes.AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    public static boolean canGooseSpawn(class_1299<EntityGoose> type, class_1936 world, class_3730 reason, class_2338 pos, Random rand) {
        class_2248 downBlock = world.method_8320(pos.method_10074()).method_26204();
        return (downBlock == class_2246.field_10219 && EntityGoose.nearWater(world, pos) || downBlock == class_2246.field_10382) && world.method_22335(pos, 0) > 8 && world.method_22347(pos);
    }

    protected static boolean nearWater(class_1936 world, class_2338 pos) {
        int i = 12;
        int j = 2;
        class_2338.class_2339 newpos = new class_2338.class_2339();
        int k = 0;
        while (k <= j) {
            for (int l = 0; l < i; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        newpos.method_10101((class_2382)pos).method_10100(i1, k - 1, j1);
                        if (newpos.method_10263() >> 4 == pos.method_10263() >> 4 && newpos.method_10260() >> 4 == pos.method_10260() >> 4 && world.method_8320((class_2338)newpos).method_26204() == class_2246.field_10382) {
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    @Override
    protected EntityGoose getBaseChild() {
        return (EntityGoose)this.getContainer().getEntityType().method_5883(this.field_6002);
    }

    @Override
    public EntityTypeContainer<EntityGoose> getContainer() {
        return ModEntities.GOOSE;
    }

    public class FindItemsGoal
    extends class_1352 {
        public FindItemsGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (!EntityGoose.this.method_6118(class_1304.field_6173).method_7960()) {
                return false;
            }
            if (EntityGoose.this.method_5968() == null && EntityGoose.this.method_6065() == null) {
                if (EntityGoose.this.method_6051().nextInt(10) != 0) {
                    return false;
                }
                List list = EntityGoose.this.field_6002.method_8390(class_1542.class, EntityGoose.this.method_5829().method_1009(8.0, 8.0, 8.0), ITEM_SELECTOR);
                return !list.isEmpty() && EntityGoose.this.method_6118(class_1304.field_6173).method_7960();
            }
            return false;
        }

        public void method_6268() {
            List list = EntityGoose.this.field_6002.method_8390(class_1542.class, EntityGoose.this.method_5829().method_1009(8.0, 8.0, 8.0), ITEM_SELECTOR);
            class_1799 itemstack = EntityGoose.this.method_6118(class_1304.field_6173);
            if (itemstack.method_7960() && !list.isEmpty()) {
                EntityGoose.this.method_5942().method_6335((class_1297)list.get(0), (double)1.2f);
            }
        }

        public void method_6269() {
            List list = EntityGoose.this.field_6002.method_8390(class_1542.class, EntityGoose.this.method_5829().method_1009(8.0, 8.0, 8.0), ITEM_SELECTOR);
            if (!list.isEmpty()) {
                EntityGoose.this.method_5942().method_6335((class_1297)list.get(0), (double)1.2f);
            }
        }
    }

    public class DislikeTargetGoal
    extends class_1405 {
        protected EntityGoose goose;

        public DislikeTargetGoal(EntityGoose goose) {
            super((class_1308)goose, true);
            this.goose = goose;
        }

        public boolean method_6264() {
            return this.goose.dislikedPlayers.size() > 0 && this.goose.method_5968() == null && this.goose.field_6012 - this.goose.lastAttackTime > 150;
        }

        protected boolean method_6328(class_1309 potentialTarget, class_4051 targetPredicate) {
            return potentialTarget instanceof class_1657 && super.method_6328(potentialTarget, targetPredicate) && EntityGoose.this.dislikedPlayers.contains(((class_1657)potentialTarget).method_7334().getId());
        }
    }
}

